﻿#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <cstrike>
#include <sdkhooks>

#define DMG_FALL (1 << 5)

public Plugin:myinfo = 
{
	name = "wS_Props_Mod",
	author = "wS / World-Source",
	description = "Мод < Строители >",
	version = "1.2",
	url = "http://my-servak.ru/"
};

new Handle:props_timer,
	Handle:ct_weapon_menu,
	Handle:ct_props_menu,
	Handle:ct_menu2,
	Handle:PropsOffkv,
	Handle:RespawnTimer,
	Handle:SpeedTimer[MAXPLAYERS+1],
	Handle:InvisTimer[MAXPLAYERS+1],
	Handle:WhereTimer[MAXPLAYERS+1];

new bool:props_on,
	bool:round_on,
	bool:CTHaveGun[MAXPLAYERS+1],
	bool:TSpawnVecFind;

new Float:props_roof_max_meters = 11.0,
	Float:SpawnPos[MAXPLAYERS+1][3],
	Float:TSpawnVecMin[3],
	Float:TSpawnVecMax[3];

new PrecH,
	props_seconds,
	props_num,
	props_he,
	props_fb,
	props_sg,
	props_fly_team,
	props_fly_time,
	props_ct_del_dissolve,
	dissolve_ent,
	props_offsound,
	PropsOff_files,
	PropsOff_files_math,
	props_roof_check_prop,
	props_only_props_menu,
	props_cash_speed,
	props_cash_invis,
	props_cash_regen,
	props_cash_where,
	props_cash_invpr,
	props_cash_delpr,
	props_featureSEC,
	props_t_timer,
	props_player_he[MAXPLAYERS+1],
	props_player_fb[MAXPLAYERS+1],
	props_player_sg[MAXPLAYERS+1];

new String:wS_Weapons[24][] = 
{
	"weapon_glock",
	"weapon_usp",
	"weapon_p228",
	"weapon_deagle",
	"weapon_elite",
	"weapon_fiveseven",
	"weapon_m3",
	"weapon_xm1014",
	"weapon_mac10",
	"weapon_tmp",
	"weapon_mp5navy",
	"weapon_ump45",
	"weapon_p90",
	"weapon_galil",
	"weapon_famas",
	"weapon_ak47",
	"weapon_m4a1",
	"weapon_scout",
	"weapon_sg550",
	"weapon_aug",
	"weapon_awp",
	"weapon_g3sg1",
	"weapon_sg552",
	"weapon_m249"
};

public OnPluginStart()
{
	wS_CreateVars();
	ServerCommand("exec wS_Props_Mod/settings.cfg");
	CreateTimer(1.0, wS_UpdateVars_Timer);

	wS_CreateCtWeaponMenu();

	ct_menu2 = CreatePanel();
	DrawPanelText(ct_menu2, "[ wS_Props_Mod ] Меню\n \n");
	DrawPanelItem(ct_menu2, "Удалить предмет");
	DrawPanelItem(ct_menu2, "Повернуть\n \n");
	DrawPanelItem(ct_menu2, "Выход");

	HookEvent("round_start", Round_Start, EventHookMode_PostNoCopy);
	HookEvent("round_end", Round_End);
	HookEvent("player_spawn", Player_Spawn);
	HookEvent("bomb_beginplant", BeginPlantC4);
	HookEvent("player_death", wS_Player_Death);
	HookEvent("weapon_fire_on_empty", wS_WeaponFireOnEmpty);

	RegConsoleCmd("props", Say_Props);
	RegConsoleCmd("fly", Say_Fly);
	RegConsoleCmd("del", Say_DelOrRot);
	RegConsoleCmd("rot", Say_DelOrRot);

	for (new i = 1; i <= MaxClients; i++)
	{
		if (IsClientInGame(i)) SDKHook(i, SDKHook_OnTakeDamage, wS_OnTakeDamage);
	}

	HookEntityOutput("prop_dynamic", "OnTakeDamage", wS_PropTakeDamage_Func);
	ServerCommand("mp_restartgame 1");
}

public OnConfigsExecuted()
{
	SetConVarInt(FindConVar("sv_hudhint_sound"), 0);
}

public Action:wS_UpdateVars_Timer(Handle:timer)
{
	props_only_props_menu = GetConVarInt(FindConVar("props_only_props_menu"));
	props_he = GetConVarInt(FindConVar("props_he"));
	props_fb = GetConVarInt(FindConVar("props_fb"));
	props_sg = GetConVarInt(FindConVar("props_sg"));
	props_fly_team = GetConVarInt(FindConVar("props_fly_team"));
	props_fly_time = GetConVarInt(FindConVar("props_fly_time"));
	props_ct_del_dissolve = GetConVarInt(FindConVar("props_ct_del_dissolve"));
	props_offsound = GetConVarInt(FindConVar("props_offsound"));
	props_roof_max_meters = GetConVarFloat(FindConVar("props_roof_max_meters"));
	props_roof_check_prop = GetConVarInt(FindConVar("props_roof_check_prop"));
	props_cash_speed = EditSum(GetConVarInt(FindConVar("props_cash_speed")));
	props_cash_invis = EditSum(GetConVarInt(FindConVar("props_cash_invis")));
	props_cash_regen = EditSum(GetConVarInt(FindConVar("props_cash_regen")));
	props_cash_where = EditSum(GetConVarInt(FindConVar("props_cash_where")));
	props_cash_invpr = EditSum(GetConVarInt(FindConVar("props_cash_invpr")));
	props_cash_delpr = EditSum(GetConVarInt(FindConVar("props_cash_delpr")));
	props_featureSEC = GetConVarInt(FindConVar("props_featureSEC"));
	if (props_featureSEC < 3 || props_featureSEC > 15) props_featureSEC = 5;

	wS_CreateCtPropsMenu();
	if (props_offsound == 1) wS_LoadPropsOffSounds();
}

EditSum(x)
{
	if (x < 100 || x > 16000) return 1000;
	return x;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

wS_CreateVars()
{
	CreateConVar("props_timer", "121");
	CreateConVar("props_control_c4", "1");
	CreateConVar("props_chang_team", "1");
	CreateConVar("props_he", "1");
	CreateConVar("props_fb", "2");
	CreateConVar("props_sg", "1");
	CreateConVar("props_fly_team", "1");
	CreateConVar("props_fly_time", "0");
	CreateConVar("props_dissolve", "1");
	CreateConVar("props_ct_del_dissolve", "1");
	CreateConVar("props_offsound", "1");
	CreateConVar("props_roof_max_meters", "11");
	CreateConVar("props_roof_check_prop", "1");
	CreateConVar("props_only_props_menu", "0");
	CreateConVar("props_min", "20");
	CreateConVar("props_cash_speed", "1000");
	CreateConVar("props_cash_invis", "1000");
	CreateConVar("props_cash_regen", "1000");
	CreateConVar("props_cash_where", "1000");
	CreateConVar("props_cash_invpr", "1000");
	CreateConVar("props_cash_delpr", "1000");
	CreateConVar("props_featureSEC", "5");
	CreateConVar("props_t_timer", "0");
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public OnMapEnd()
{
	if (PropsOffkv != INVALID_HANDLE)
	{
		CloseHandle(PropsOffkv);
		PropsOffkv = INVALID_HANDLE;
	}
	wS_CreateCtWeaponMenu();
	ServerCommand("exec wS_Props_Mod/settings.cfg");
	CreateTimer(1.0, wS_UpdateVars_Timer);
}

public OnMapStart()
{
	RespawnTimer = INVALID_HANDLE;
	PrecH = PrecacheModel("materials/sprites/halo01.vmt");
	dissolve_ent = 0;
	wS_StopProps();

	TSpawnVecFind = false;
	new i = -1;
	while ((i = FindEntityByClassname(i, "func_buyzone")) > 0)
	{
		if (GetEntProp(i, Prop_Send, "m_iTeamNum") == 2)
		{
			GetEntPropVector(i, Prop_Send, "m_vecMins", TSpawnVecMin);
			GetEntPropVector(i, Prop_Send, "m_vecMaxs", TSpawnVecMax);
			TSpawnVecFind = true;
			break;
		}
	}
}

wS_CreateCtPropsMenu()
{
	if (ct_props_menu != INVALID_HANDLE) CloseHandle(ct_props_menu);
	ct_props_menu = CreateMenu(select_ct_props_menu);
	SetMenuTitle(ct_props_menu, "[ wS_Props_Mod ] Меню\n \n");
	new Handle:kv = CreateKeyValues("ct_props_menu");
	if (!FileToKeyValues(kv, "cfg/wS_Props_Mod/ct_props_menu.txt"))
	{
		LogError("cfg/wS_Props_Mod/ct_props_menu.txt NOT FOUND");
		return;
	}
	if (!KvGotoFirstSubKey(kv))
	{
		CloseHandle(kv);
		LogError("cfg/wS_Props_Mod/ct_props_menu.txt ERROR");
		return;
	}
	if (props_only_props_menu != 1)
	{
		AddMenuItem(ct_props_menu, "delete", "Удалить предмет");
		AddMenuItem(ct_props_menu, "rotate", "Повернуть\n \n");
	}
	new String:wS_ModelName[95], String:wS_Model[95], sz, props = 2;
	sz = sizeof(wS_Model);
	do
	{
		KvGetSectionName(kv, wS_ModelName, sizeof(wS_ModelName));
		TrimString(wS_ModelName);
		KvGetString(kv, "model", wS_Model, sz);
		TrimString(wS_Model);
		if (strlen(wS_Model) < 7)
		{
			LogError("model (%s) ERROR", wS_ModelName);
			continue;
		}
		ReplaceString(wS_Model, sizeof(wS_Model), "\\", "/");
		if (StrContains(wS_Model, "models/") == -1) Format(wS_Model, sz, "models/%s", wS_Model);
		if (StrContains(wS_Model, ".mdl") == -1) Format(wS_Model, sz, "%s.mdl", wS_Model);
		if (props_only_props_menu != 1 && ++props == 8)
		{
			AddMenuItem(ct_props_menu, "delete", "Удалить предмет");
			AddMenuItem(ct_props_menu, "rotate", "Повернуть\n \n");
			props = 3;
		}
		AddMenuItem(ct_props_menu, wS_Model, wS_ModelName);
		if (!IsModelPrecached(wS_Model)) PrecacheModel(wS_Model, true);
	}
	while (KvGotoNextKey(kv));
	CloseHandle(kv);
}

wS_CreateCtWeaponMenu()
{
	if (ct_weapon_menu != INVALID_HANDLE) CloseHandle(ct_weapon_menu);
	ct_weapon_menu = CreateMenu(select_ct_weapon_menu);
	SetMenuTitle(ct_weapon_menu, "Выберите оружие:\n \n");
	new Handle:kv = CreateKeyValues("ct_weapon_menu");
	if (!FileToKeyValues(kv, "cfg/wS_Props_Mod/ct_weapon_menu.txt"))
	{
		AddMenuItem(ct_weapon_menu, "weapon_deagle", "Кольт (deagle)");
		AddMenuItem(ct_weapon_menu, "weapon_usp", "KM .45 Tactical (usp)");
		AddMenuItem(ct_weapon_menu, "weapon_p228", "228 Compact");
		AddMenuItem(ct_weapon_menu, "weapon_elite", ".40 Dual Elites");
		AddMenuItem(ct_weapon_menu, "weapon_fiveseven", "ES Five-Seven");
		AddMenuItem(ct_weapon_menu, "weapon_glock", "Glock");
		LogError("cfg/wS_Props_Mod/ct_weapon_menu.txt NOT FOUND");
		return;
	}
	else if (KvGotoFirstSubKey(kv))
	{
		decl String:wS_WeaponName[75], String:wS_Weapon[35];
		do
		{
			KvGetString(kv, "classname", wS_Weapon, sizeof(wS_Weapon));
			TrimString(wS_Weapon);
			if (wS_FindWeapon(wS_Weapon))
			{
				KvGetSectionName(kv, wS_WeaponName, sizeof(wS_WeaponName));
				TrimString(wS_WeaponName);
				AddMenuItem(ct_weapon_menu, wS_Weapon, wS_WeaponName);
			}
			else LogError("Название оружия в ct_weapon_menu.txt неверно: %s", wS_Weapon);
		}
		while (KvGotoNextKey(kv)); 
	}
	CloseHandle(kv);
}

wS_StopProps()
{
	props_on      = false;
	props_timer   = INVALID_HANDLE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public Round_Start(Handle:event, const String:name[], bool:dontBroadcast)
{
	round_on = true;
	new Prop_Index = -1;
	while ((Prop_Index = FindEntityByClassname(Prop_Index, "prop_dynamic")) > 0)
	{
		AcceptEntityInput(Prop_Index, "Kill");
	}
	dissolve_ent = CreateEntityByName("env_entity_dissolver");
	if (props_timer != INVALID_HANDLE)
	{
		KillTimer(props_timer);
		props_timer = INVALID_HANDLE;
	}
	if (RespawnTimer != INVALID_HANDLE)
	{
		KillTimer(RespawnTimer);
		RespawnTimer = INVALID_HANDLE;
	}
	RespawnTimer = CreateTimer(5.0, RespawnTimer_func, _, TIMER_REPEAT|TIMER_FLAG_NO_MAPCHANGE);
	for (new i = 1; i <= MaxClients; i++)
	{
		CTHaveGun[i] = false;
		props_player_he[i] = 0;
		props_player_fb[i] = 0;
		props_player_sg[i] = 0;
	}
	props_on  = true;
	props_num = 0;
	if ((props_seconds = GetConVarInt(FindConVar("props_timer")) + 1) < 10 || props_seconds > 541) props_seconds = 121;
	props_timer = CreateTimer(1.0, props_timer_func, _, TIMER_REPEAT|TIMER_FLAG_NO_MAPCHANGE);
}

public Round_End(Handle:event, const String:name[], bool:dontBroadcast)
{
	round_on = false;
	if (GetConVarInt(FindConVar("props_dissolve")) == 1 && props_num > 0)
	{
		wS_Dissolve("wS_prop", "0");
	}
	wS_StopProps();
	if (GetEventInt(event, "winner") < 2)
	{
		return;
	}
	if (GetConVarInt(FindConVar("props_chang_team")) == 1)
	{
		decl t;
		for (new i = 1; i <= MaxClients; i++)
		{
			if (IsClientInGame(i) && (t = GetClientTeam(i)) > 1)
			{
				if (t == 2) CS_SwitchTeam(i, 3);
				else CS_SwitchTeam(i, 2);
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public Action:props_timer_func(Handle:timer, any:wS)
{
	if (!props_on) return Plugin_Stop;
	if (!wS_FindAlivePlayers())
	{
		wS_StopProps();
		PrintToChatAll("\x01[ \x03wS_Props_Mod\x01 ] \x05СТОП. \x01Одна из команд \x04мертва.");
		return Plugin_Stop;
	}
	props_seconds -= 1;
	if (props_seconds > 0)
	{
		PrintHintTextToAll("[ wS_Props_Mod ] До завершения строительства:\n <<< %d сек >>>", props_seconds);
		return Plugin_Continue;
	}

	// СТРОИТЕЛЬСТВО ЗАВЕРШЕНО
	wS_StopProps();
	PrintToChatAll("\x01[ \x03wS_Props_Mod\x01 ] \x05Строительство \x04завершено\x01 (\x03%d\x01)", props_num);
	if (RespawnTimer != INVALID_HANDLE)
	{
		KillTimer(RespawnTimer);
		RespawnTimer = INVALID_HANDLE;
	}

	// убиваем ct
	new props_min = GetConVarInt(FindConVar("props_min")), bad_ct_num = 0;
	if (props_min > 0 && props_num < props_min)
	{
		for (new i = 1; i <= MaxClients; i++)
		{
			if (IsClientInGame(i) && IsPlayerAlive(i) && GetClientTeam(i) == 3)
			{
				ForcePlayerSuicide(i);
				bad_ct_num += 1;
			}
		}
		if (bad_ct_num > 0)
		{
			PrintToChatAll("\x01[ \x03wS_Props_Mod\x01 ] \x05Все \x04Контр-Террористы \x01убиты.");
			PrintToChatAll("\x01[ \x03wS_Props_Mod\x01 ] Создано предметов: \x04%d. \x01Необходимо минимум: \x04%d.", props_num, props_min);
		}
		return Plugin_Stop;
	}

	for (new i = 1; i <= MaxClients; i++)
	{
		if (IsClientInGame(i) && IsPlayerAlive(i))
		{
			SetEntProp(i, Prop_Data, "m_takedamage", 2);
			if (props_fly_time == 1 && props_fly_team > 0)
			{
				SetEntityMoveType(i, MOVETYPE_WALK);
			}
			if (GetClientTeam(i) == 2)
			{
				TeleportEntity(i, SpawnPos[i], NULL_VECTOR, NULL_VECTOR);
			}
			else
			{
				if (!CTHaveGun[i] && GetPlayerWeaponSlot(i, 1) < 1)
				{
					GivePlayerItem(i, "weapon_deagle");
					CTHaveGun[i] = true;
				}
			}
		}
	}
	if (props_offsound == 1 && PropsOffkv != INVALID_HANDLE)
	{
		wS_PlayAllPropsOffSound();
	}
	if (4 < (props_t_timer = GetConVarInt(FindConVar("props_t_timer"))) < 501)
	{
		CreateTimer(1.0, wS_T_Timer, _, TIMER_REPEAT|TIMER_FLAG_NO_MAPCHANGE);
	}
	return Plugin_Stop;
}

public Action:wS_T_Timer(Handle:timer, any:wS_Schmidt)
{
	if (props_on || !round_on) return Plugin_Stop;
	props_t_timer -= 1;
	if (props_t_timer < 1)
	{
		for (new i = 1; i <= MaxClients; i++)
		{
			if (IsClientInGame(i) && IsPlayerAlive(i) && GetClientTeam(i) == 2)
			{
				ForcePlayerSuicide(i);
			}
		}
		return Plugin_Stop;
	}
	else if (props_t_timer < 31)
	{
		PrintHintTextToAll("[ wS_Props_Mod ] Террористы будут убиты через:\n <<< %d сек >>>", props_t_timer);
	}
	return Plugin_Continue;
}

bool:wS_FindAlivePlayers()
{
	new t = 0;
	for (new i = 1; i <= MaxClients; i++)
	{
		if (IsClientInGame(i) && IsPlayerAlive(i))
		{
			if (t == 0) t = GetClientTeam(i);
			else if (t != GetClientTeam(i)) return true;
		}
	}
	return false;
}

bool:wS_FindWeapon(const String:wS_Weapon[])
{
	for (new i = 0; i < 24; i++)
	{
		if (StrEqual(wS_Weapon, wS_Weapons[i])) return true;
	}
	return false;
}

wS_PropsOnPlayer(i)
{
	SetEntProp(i, Prop_Data, "m_takedamage", 0);
	SetEntProp(i, Prop_Data, "m_CollisionGroup", 2);
	if (GetClientTeam(i) == 3)
	{
		DisplayMenu(ct_weapon_menu, i, 10);
	}
	else
	{
		SetEntProp(i, Prop_Send, "m_iAccount", 16000);
	}
}

public Player_Spawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new i = GetClientOfUserId(GetEventInt(event, "userid"));
	GetClientAbsOrigin(i, SpawnPos[i]);
	if (!IsFakeClient(i))
	{
		wS_SetOnlyKnife(i);
		wS_StopTimers(i);
		if (props_on) wS_PropsOnPlayer(i);
		else
		{
			CreateTimer(1.0, Player_Spawn_Timer, i);
		}
	}
}

public Action:Player_Spawn_Timer(Handle:timer, any:i)
{
	if (props_on && IsClientInGame(i) && IsPlayerAlive(i)) wS_PropsOnPlayer(i);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public Action:wS_OnTakeDamage(i, &a, &inflictor, &Float:damage, &damagetype)
{
	if (damagetype & DMG_FALL) return Plugin_Handled;
	if (props_roof_max_meters > 0.9 && 0 < a <= MaxClients && GetClientTeam(a) == 3 && GetClientTeam(i) == 2)
	{
		decl Float:EyePosition[3], Float:end_origin[3], Handle:h_trace;
		GetClientEyePosition(a, EyePosition);
		h_trace = TR_TraceRayFilterEx(EyePosition, Float:{-90.0,90.0,0.0}, MASK_SOLID, RayType_Infinite, wS_Filter, a);
		TR_GetEndPosition(end_origin, h_trace);
		if ((GetVectorDistance(EyePosition, end_origin) / 39.3) > props_roof_max_meters)
		{
			CloseHandle(h_trace);
			ClientCommand(a, "lastinv");
			PrintToChat(a, "\x01[ \x05wS_Props_Mod\x01 ] \x01Вы должны быть \x03в сооружении.");
			return Plugin_Handled;
		}
		if (props_roof_check_prop == 1)
		{
			decl Prop_Index;
			if ((Prop_Index = TR_GetEntityIndex(h_trace)) > 0)
			{
				decl String:wS_Name[20];
				GetEntityClassname(Prop_Index, wS_Name, sizeof(wS_Name));
				if (!StrEqual(wS_Name, "prop_dynamic"))
				{
					CloseHandle(h_trace);
					ClientCommand(a, "lastinv");
					PrintToChat(a, "\x01[ \x05wS_Props_Mod\x01 ] \x01Вы должны быть \x03в сооружении.");
					return Plugin_Handled;
				}
			}
			else
			{
				CloseHandle(h_trace);
				ClientCommand(a, "lastinv");
				PrintToChat(a, "\x01[ \x05wS_Props_Mod\x01 ] \x01Вы должны быть \x03в сооружении.");
				return Plugin_Handled;
			}
		}
		CloseHandle(h_trace);
	}
	return Plugin_Continue;
}

public OnClientPutInServer(i)
{
	SDKHook(i, SDKHook_OnTakeDamage, wS_OnTakeDamage);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public select_ct_weapon_menu(Handle:menu, MenuAction:action, i, option)
{
	if (props_on && action == MenuAction_Select && GetClientTeam(i) == 3 && IsPlayerAlive(i))
	{
		if (GetPlayerWeaponSlot(i, 1) < 1)
		{
			decl String:weapon[35];
			GetMenuItem(menu, option, weapon, sizeof(weapon));
			GivePlayerItem(i, weapon);
			DisplayMenu(ct_props_menu, i, 0);
			CTHaveGun[i] = true;
		}
		else PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] \x01У вас \x03уже есть \x01оружие.");
	}
}

wS_SetOnlyKnife(i)
{
	decl Index;
	for (new x = 0; x < 2; x++)
	{
		if ((Index = GetPlayerWeaponSlot(i, x)) > 0)
		{
			RemovePlayerItem(i, Index);
		}
	}
	// remove all grenades
	for (new y = 1; y < 5; y++)
	{
		if ((Index = GetPlayerWeaponSlot(i, 3)) > 0)
		{
			RemovePlayerItem(i, Index);
		}
		else break;
	}
	ClientCommand(i, "lastinv");
}

public BeginPlantC4(Handle:event, const String:name[], bool:dontBroadcast)
{
	if (GetConVarInt(FindConVar("props_control_c4")) == 1)
	{
		new i = GetClientOfUserId(GetEventInt(event, "userid")), Index;
		if ((Index = GetPlayerWeaponSlot(i, 4)) > 0)
		{
			RemovePlayerItem(i, Index);
			ClientCommand(i, "lastinv");
			PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] \x03Ставить бомбу \x04запрещено.");
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public select_ct_props_menu(Handle:menu, MenuAction:action, i, option)
{
	if (action != MenuAction_Select || GetClientTeam(i) != 3 || !IsPlayerAlive(i))
	{
		return;
	}
	decl String:wS_Info[75];
	GetMenuItem(menu, option, wS_Info, sizeof(wS_Info));
	if (props_only_props_menu != 1)
	{
		decl bool:its_delete;
		if ((its_delete = StrEqual(wS_Info, "delete")) || StrEqual(wS_Info, "rotate"))
		{
			if (props_num < 1)
			{
				PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Нет \x03созданных \x04предметов.");
			}
			else
			{
				wS_RotateOrDeleteProp(i, its_delete);
				DisplayMenuAtItem(menu, i, GetMenuSelectionPosition(), 0);
			}
			return;
		}
	}
	if (!props_on)
	{
		if (props_num > 0) SendPanelToClient(ct_menu2, i, select_ct_menu2, 0);
		return;
	}
	// СОЗДАЕМ ПРОП
	decl Float:EyePosition[3], Float:EyeAngles[3], Float:end_origin[3];
	GetClientEyePosition(i, EyePosition);
	GetClientEyeAngles(i, EyeAngles);
	TR_TraceRayFilter(EyePosition, EyeAngles, MASK_SOLID, RayType_Infinite, wS_Filter, i);
	TR_GetEndPosition(end_origin, INVALID_HANDLE);
	if (TSpawnVecFind && TSpawnVecMin[0] <= end_origin[0] <= TSpawnVecMax[0] && TSpawnVecMin[1] <= end_origin[1] <= TSpawnVecMax[1])
	{
		PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Не застраивайте \x04респ \x01Террористов.");
		return;
	}
	decl p_index;
	if ((p_index = CreateEntityByName("prop_dynamic")) < MaxClients)
	{
		PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Не удалось \x03создать \x04проп.");
		return;
	}
	decl Float:prop_angles[3];
	TR_GetPlaneNormal(INVALID_HANDLE, prop_angles);
	GetVectorAngles(prop_angles, prop_angles);
	prop_angles[0] += 90.0;
	DispatchKeyValue(p_index, "targetname", "wS_prop");
	DispatchKeyValue(p_index, "model", wS_Info);
	DispatchKeyValue(p_index, "solid", "6");
	DispatchSpawn(p_index);
	TeleportEntity(p_index, end_origin, prop_angles, NULL_VECTOR);
	SetEntPropEnt(p_index, Prop_Send, "m_PredictableID", i);
	props_num += 1;
	DisplayMenuAtItem(menu, i, GetMenuSelectionPosition(), 0);
}

public bool:wS_Filter(ent, mask, any:i)
{
	return i != ent;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

wS_Rotate(index)
{
	decl Float:angles[3], Float:direction[3], Float:normal[3], Float:a, Float:b, Float:c, Float:x, Float:y, Float:z;
	GetEntPropVector(index, Prop_Send, "m_angRotation", angles);
	GetAngleVectors(angles, direction, NULL_VECTOR, normal);
	a = normal[0] * 0.707106;
	b = normal[1] * 0.707106;
	c = normal[2] * 0.707106;
	x = direction[2] * b + direction[0] * 0.707107 - direction[1] * c;
	y = direction[0] * c + direction[1] * 0.707107 - direction[2] * a;
	z = direction[1] * a + direction[2] * 0.707107 - direction[0] * b;
	direction[0] = x;
	direction[1] = y;
	direction[2] = z;
	GetVectorAngles(direction, angles);
	decl Float:up[3];
	GetVectorVectors(direction, NULL_VECTOR, up);
	new Float:roll = GetAngleBetweenVectors(up, normal, direction);
	angles[2] += roll;
	TeleportEntity(index, NULL_VECTOR, angles, NULL_VECTOR);
}

Float:GetAngleBetweenVectors(const Float:vector1[3], const Float:vector2[3], const Float:direction[3])
{
	decl Float:vector1_n[3], Float:vector2_n[3], Float:direction_n[3], Float:cross[3];
	NormalizeVector(direction, direction_n);
	NormalizeVector(vector1, vector1_n);
	NormalizeVector(vector2, vector2_n);
	new Float:degree = ArcCosine(GetVectorDotProduct(vector1_n, vector2_n)) * 57.29577951;
	GetVectorCrossProduct(vector1_n, vector2_n, cross);
	if (GetVectorDotProduct(cross, direction_n) < 0.0) degree *= -1.0;
	return degree;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

wS_RotateOrDeleteProp(i, bool:its_delete)
{
	new Prop_Index = wS_GetLookPropIndex(i);
	if (Prop_Index > 0)
	{
		if (its_delete)
		{
			if (props_ct_del_dissolve == 1)
			{
				SetEntPropEnt(Prop_Index, Prop_Send, "m_PredictableID", 0);
				DispatchKeyValue(Prop_Index, "targetname", "wS_ct_dis_prop");
				wS_Dissolve("wS_ct_dis_prop", "3");
			}
			else AcceptEntityInput(Prop_Index, "Kill");
			props_num -= 1;
		}
		else
		{
			wS_Rotate(Prop_Index);
		}
	}
}

public select_ct_menu2(Handle:menu, MenuAction:action, i, z)
{
	if (action == MenuAction_Select && z < 3 && GetClientTeam(i) == 3 && IsPlayerAlive(i))
	{
		if (props_num < 1)
		{
			PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Нет \x03созданных \x04предметов.");
			return;
		}
		if (z == 1) wS_RotateOrDeleteProp(i, true);
		else wS_RotateOrDeleteProp(i, false);
		SendPanelToClient(ct_menu2, i, select_ct_menu2, 0);
	}
}

public Action:Say_Props(i, args)
{
	if (args > 0 || !IsPlayerAlive(i))
	{
		return Plugin_Handled;
	}
	if (GetClientTeam(i) == 3)
	{
		if (props_on) DisplayMenu(ct_props_menu, i, 0);
		else SendPanelToClient(ct_menu2, i, select_ct_menu2, 0);
	}
	else if (GetEntProp(i, Prop_Send, "m_iAccount") > 99) wS_ShowRedBonusMenu(i);
	else PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] У вас \x05недостаточно \x01денег");
	return Plugin_Handled;
}

public Action:CS_OnBuyCommand(i, const String:weapon[])
{
	if (GetClientTeam(i) == 3)
	{
		PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] \x04Покупать \x01оружие \x03запрещено.");
		return Plugin_Handled;
	}
	if (props_on)
	{
		PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Будет доступно \x03после \x04строительства.");
		return Plugin_Handled;
	}
	if (StrEqual(weapon, "hegrenade"))
	{
		if (props_player_he[i] >= props_he)
		{
			PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Эта \x03граната\x01 уже \x04недоступна.");
			return Plugin_Handled;
		}
		props_player_he[i] += 1;
	}
	else if (StrEqual(weapon, "flashbang"))
	{
		if (props_player_fb[i] >= props_fb)
		{
			PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Эта \x03граната\x01 уже \x04недоступна.");
			return Plugin_Handled;
		}
		props_player_fb[i] += 1;
	}
	else if (StrEqual(weapon, "smokegrenade"))
	{
		if (props_player_sg[i] >= props_sg)
		{
			PrintToChat(i, "\x01[ \x05wS_Props_Mod\x01 ] Эта \x03граната\x01 уже \x04недоступна.");
			return Plugin_Handled;
		}
		props_player_sg[i] += 1;
	}
	return Plugin_Continue;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public Action:Say_Fly(i, args)
{
	if (args > 0 || props_fly_team == 0 || !IsPlayerAlive(i) || props_fly_time == 1 && !props_on || props_fly_time == 2 && props_on)
	{
		return Plugin_Handled;
	}
	if (props_fly_team == 1 || GetClientTeam(i) == props_fly_team)
	{
		if (GetEntityMoveType(i) != MOVETYPE_FLY) SetEntityMoveType(i, MOVETYPE_FLY);
		else SetEntityMoveType(i, MOVETYPE_WALK);
	}
	return Plugin_Handled;
}

wS_Dissolve(const String:Target[], const String:Type[])
{
	if (dissolve_ent > 0)
	{
		DispatchKeyValue(dissolve_ent, "target", Target);
		DispatchKeyValue(dissolve_ent, "magnitude", "1");
		DispatchKeyValue(dissolve_ent, "dissolvetype", Type);
		AcceptEntityInput(dissolve_ent, "Dissolve");
	}
}

public wS_PropTakeDamage_Func(const String:output[], ent, i, Float:delay)
{
	if (!round_on)
	{
		return;
	}
	if (props_on && GetClientTeam(i) == 2)
	{
		decl String:weapon[15];
		GetClientWeapon(i, weapon, sizeof(weapon));
		if (StrEqual(weapon, "weapon_knife"))
		{
			TeleportEntity(i, SpawnPos[i], NULL_VECTOR, NULL_VECTOR);
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Ножом по предмету = \x05телепорт.");
			ClientCommand(i, "playgamesound physics/metal/chain_impact_hard2.wav");
			return;
		}
	}
	decl vladec_i;
	if ((vladec_i = GetEntPropEnt(ent, Prop_Send, "m_PredictableID")) > 0 && vladec_i != i && IsClientInGame(vladec_i))
	{
		PrintCenterText(i, "Владелец предмета: %N", vladec_i);
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

wS_LoadPropsOffSounds()
{
	new Handle:h = OpenDirectory("sound/wS_Props_Mod/props_off");
	if (h == INVALID_HANDLE)
	{
		props_offsound = 0;
		LogError("Не удалось открыть директорию sound/wS_Props_Mod/props_off");
		return;
	}
	PropsOffkv = CreateKeyValues("PropsOffSounds");
	if (PropsOffkv == INVALID_HANDLE)
	{
		props_offsound = 0;
		LogError("PropsOffkv INVALID_HANDLE");
		return;
	}
	PropsOff_files = 0;
	new String:FileName[75], FileName_sz, FileType:type, String:Str_Num[10], Num_sz;
	FileName_sz = sizeof(FileName);
	Num_sz = sizeof(Str_Num);
	while (ReadDirEntry(h, FileName, FileName_sz, type))
	{
		if (type == FileType_File)
		{
			PropsOff_files += 1;
			IntToString(PropsOff_files, Str_Num, Num_sz);
			KvJumpToKey(PropsOffkv, Str_Num, true);
			Format(FileName, FileName_sz, "sound/wS_Props_Mod/props_off/%s", FileName);
			AddFileToDownloadsTable(FileName);
			ReplaceString(FileName, FileName_sz, "sound/", "");
			KvSetString(PropsOffkv, "sound", FileName);
			KvRewind(PropsOffkv);
		}
	}
	CloseHandle(h);
	if (PropsOff_files < 1)
	{
		props_offsound = 0;
		LogError("В sound/wS_Props_Mod/props_off нет звуков");
		CloseHandle(PropsOffkv);
		PropsOffkv = INVALID_HANDLE;
	}
}

wS_PlayAllPropsOffSound()
{
	if (PropsOff_files_math > PropsOff_files || PropsOff_files_math < 1) PropsOff_files_math = 1;
	decl String:Str_Num[10];
	IntToString(PropsOff_files_math, Str_Num, sizeof(Str_Num));
	if (KvJumpToKey(PropsOffkv, Str_Num))
	{
		decl String:wS_Sound[75];
		KvGetString(PropsOffkv, "sound", wS_Sound, sizeof(wS_Sound));
		KvRewind(PropsOffkv);
		for (new i = 1; i <= MaxClients; i++)
		{
			if (IsClientInGame(i)) ClientCommand(i, "playgamesound %s", wS_Sound);
		}
	}
	else LogError("Не удалось найти ключ (%s) в PropsOffkv", Str_Num);
	PropsOff_files_math += 1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

wS_ShowRedBonusMenu(i)
{
	decl Handle:p;
	if ((p = CreatePanel()) == INVALID_HANDLE)
	{
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Не удалось \x05создать \x01меню");
		return;
	}
	new wS_Cash = GetEntProp(i, Prop_Send, "m_iAccount");
	DrawPanelText(p, "[ wS_Props_Mod ] Магазин\n \n");
	decl String:f[100];
	Format(f, sizeof(f), "Скорость %d сек ($%d)", props_featureSEC, props_cash_speed);
	if (wS_Cash < props_cash_speed || SpeedTimer[i] != INVALID_HANDLE) DrawPanelItem(p, f, ITEMDRAW_DISABLED);
	else DrawPanelItem(p, f);
	Format(f, sizeof(f), "Невидимость %d сек ($%d)", props_featureSEC, props_cash_invis);
	if (wS_Cash < props_cash_invis || InvisTimer[i] != INVALID_HANDLE) DrawPanelItem(p, f, ITEMDRAW_DISABLED);
	else DrawPanelItem(p, f);
	Format(f, sizeof(f), "Оздоровление ($%d)", props_cash_regen);
	if (wS_Cash < props_cash_regen || props_on) DrawPanelItem(p, f, ITEMDRAW_DISABLED);
	else DrawPanelItem(p, f);
	Format(f, sizeof(f), "Узнать где враги ($%d)", props_cash_where);
	if (wS_Cash < props_cash_where || WhereTimer[i] != INVALID_HANDLE) DrawPanelItem(p, f, ITEMDRAW_DISABLED);
	else DrawPanelItem(p, f);
	Format(f, sizeof(f), "Просветить предмет ($%d)", props_cash_invpr);
	if (wS_Cash < props_cash_invpr || props_on) DrawPanelItem(p, f, ITEMDRAW_DISABLED);
	else DrawPanelItem(p, f);
	Format(f, sizeof(f), "Удалить предмет ($%d)\n \n", props_cash_delpr);
	if (wS_Cash < props_cash_delpr || props_on) DrawPanelItem(p, f, ITEMDRAW_DISABLED);
	else DrawPanelItem(p, f);
	DrawPanelItem(p, "Выход");
	SendPanelToClient(p, i, Select_RedBonusMenu, 0);
	CloseHandle(p);
}

public Select_RedBonusMenu(Handle:menu, MenuAction:action, i, option)
{
	if (action != MenuAction_Select || option > 6 || GetClientTeam(i) != 2)
	{
		return;
	}
	new wS_Cash = GetEntProp(i, Prop_Send, "m_iAccount");
	if (option == 1)
	{
		if (wS_Cash < props_cash_speed)
		{
			wS_ErrorMsgNoCash(i);
			return;
		}
		if (SpeedTimer[i] != INVALID_HANDLE)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Скорость \x05УЖЕ \x01прокачана");
			return;
		}
		SetEntProp(i, Prop_Send, "m_iAccount", wS_Cash - props_cash_speed);
		SetEntPropFloat(i, Prop_Send, "m_flLaggedMovementValue", 3.0);
		SpeedTimer[i] = CreateTimer(float(props_featureSEC), StopSpeed_Func, i, TIMER_FLAG_NO_MAPCHANGE);
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Скорость \x04активирована");
		ClientCommand(i, "playgamesound weapons/flashbang/flashbang_explode1.wav");
	}
	else if (option == 2)
	{
		if (wS_Cash < props_cash_invis)
		{
			wS_ErrorMsgNoCash(i);
			return;
		}
		if (InvisTimer[i] != INVALID_HANDLE)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Невидимость \x05УЖЕ \x01прокачана");
			return;
		}
		SetEntProp(i, Prop_Send, "m_iAccount", wS_Cash - props_cash_invis);
		wS_SetColor(i, 255, 255, 255, 25);
		InvisTimer[i] = CreateTimer(float(props_featureSEC), StopInvis_Func, i, TIMER_FLAG_NO_MAPCHANGE);
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Невидимость \x04активирована");
		ClientCommand(i, "playgamesound weapons/elite/elite_deploy.wav");
	}
	else if (option == 3)
	{
		if (wS_Cash < props_cash_regen)
		{
			wS_ErrorMsgNoCash(i);
			return;
		}
		if (GetEntProp(i, Prop_Send, "m_iHealth") > 99)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Вы и так \x05здоровы");
			return;
		}
		SetEntProp(i, Prop_Send, "m_iAccount", wS_Cash - props_cash_regen);
		SetEntProp(i, Prop_Send, "m_iHealth", 100);
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Здоровье \x04восстановлено");
		wS_Vertical_Effect(i, {0,255,0,255});
		ClientCommand(i, "playgamesound ui/freeze_cam.wav");
	}
	else if (option == 4)
	{
		if (wS_Cash < props_cash_where)
		{
			wS_ErrorMsgNoCash(i);
			return;
		}
		if (WhereTimer[i] != INVALID_HANDLE)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Ждите \x0510 \x01секунд");
			return;
		}
		SetEntProp(i, Prop_Send, "m_iAccount", wS_Cash - props_cash_where);
		decl Float:MyPos[3], Float:TargetPos[3];
		GetClientAbsOrigin(i, MyPos);
		MyPos[2] += 500.0;
		new targets = 0;
		for (new x = 1; x <= MaxClients; x++)
		{
			if (IsClientInGame(x) && IsPlayerAlive(x) && GetClientTeam(x) == 3)
			{
				GetClientAbsOrigin(x, TargetPos);
				TE_SetupBeamPoints(MyPos, TargetPos, PrecH, PrecH, 0, 0, 5.0, 25.0, 1.0, 0, 0.0, {255,0,0,255}, 50);
				TE_SendToClient(i);
				targets += 1;
			}
		}
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Найдено врагов: \x05%d", targets);
		ClientCommand(i, "playgamesound ambient/office/button1.wav");
		WhereTimer[i] = CreateTimer(10.0, StopWhere_Func, i, TIMER_FLAG_NO_MAPCHANGE);
	}
	else if (option == 5)
	{
		if (wS_Cash < props_cash_invpr)
		{
			wS_ErrorMsgNoCash(i);
			return;
		}
		if (props_on)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Ждите \x05окончания \x01строительства");
			return;
		}
		new Prop_Index = wS_GetLookPropIndex(i);
		if (Prop_Index < 1)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Вы должны \x05смотреть \x01на предмет");
			return;
		}
		if (GetEntProp(Prop_Index, Prop_Send, "m_clrRender") == 436207615)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Этот предмет \x05уже \x01просвещен");
			return;
		}
		SetEntProp(i, Prop_Send, "m_iAccount", wS_Cash - props_cash_invpr);
		wS_SetColor(Prop_Index, 255, 255, 255, 25);
		CreateTimer(5.0, StopInvpr_Func, Prop_Index, TIMER_FLAG_NO_MAPCHANGE);
		ClientCommand(i, "playgamesound physics/plastic/plastic_box_strain2.wav");
	}
	else if (option == 6)
	{
		if (wS_Cash < props_cash_delpr)
		{
			wS_ErrorMsgNoCash(i);
			return;
		}
		if (props_on)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Ждите \x05окончания \x01строительства");
			return;
		}
		new Prop_Index = wS_GetLookPropIndex(i);
		if (Prop_Index < 1)
		{
			PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Вы должны \x05смотреть \x01на предмет");
			return;
		}
		SetEntProp(i, Prop_Send, "m_iAccount", wS_Cash - props_cash_delpr);
		new vladelec_i = GetEntPropEnt(Prop_Index, Prop_Send, "m_PredictableID");
		if (vladelec_i > 0 && IsClientInGame(vladelec_i) && IsPlayerAlive(vladelec_i))
		{
			PrintCenterText(vladelec_i, "ВНИМАНИЕ! %N удалил ваш проп!", i);
		}
		SetEntPropEnt(Prop_Index, Prop_Send, "m_PredictableID", 0);
		DispatchKeyValue(Prop_Index, "targetname", "wS_t_dis_prop");
		wS_Dissolve("wS_t_dis_prop", "1");
		props_num -= 1;
		ClientCommand(i, "playgamesound physics/cardboard/cardboard_box_break1.wav");
	}
	wS_ShowRedBonusMenu(i);
}

wS_ErrorMsgNoCash(i)
{
	PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] У вас \x05недостаточно \x01денег");
	ClientCommand(i, "playgamesound resource/warning.wav");
}

wS_Vertical_Effect(i, wS_Color[4])
{
	decl Float:wS_Pos1[3], Float:wS_Pos2[3];
	GetClientAbsOrigin(i, wS_Pos1);
	wS_Pos2[0] = wS_Pos1[0];
	wS_Pos2[1] = wS_Pos1[1];
	wS_Pos2[2] = wS_Pos1[2] + 70.0;
	TE_SetupBeamPoints(wS_Pos1, wS_Pos2, PrecH, PrecH, 0, 0, 0.2, 50.0, 90.0, 0, 0.0, wS_Color, 50);
	TE_SendToAll();
}

wS_SetColor(i, r, g, b, a)
{
	SetEntityRenderMode(i, RENDER_TRANSCOLOR);
	SetEntityRenderColor(i, r, g, b, a);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public Action:StopSpeed_Func(Handle:timer, any:i)
{
	if (IsPlayerAlive(i) && SpeedTimer[i] != INVALID_HANDLE)
	{
		SetEntPropFloat(i, Prop_Send, "m_flLaggedMovementValue", 1.0);
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Скорость отключена");
		SpeedTimer[i] = INVALID_HANDLE;
		wS_ShowRedBonusMenu(i);
	}
}

public Action:StopInvis_Func(Handle:timer, any:i)
{
	if (IsPlayerAlive(i) && InvisTimer[i] != INVALID_HANDLE)
	{
		wS_SetColor(i, 255, 255, 255, 255);
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Невидимость отключена");
		InvisTimer[i] = INVALID_HANDLE;
		wS_ShowRedBonusMenu(i);
	}
}

public Action:StopWhere_Func(Handle:timer, any:i)
{
	WhereTimer[i] = INVALID_HANDLE;
	wS_ShowRedBonusMenu(i);
}

public Action:StopInvpr_Func(Handle:timer, any:i)
{
	if (!props_on && IsValidEntity(i)) wS_SetColor(i, 255, 255, 255, 255);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public wS_Player_Death(Handle:event, const String:name[], bool:dontBroadcast)
{
	wS_StopTimers(GetClientOfUserId(GetEventInt(event, "userid")));
}

public OnClientDisconnect(i)
{
	wS_StopTimers(i);
}

wS_StopTimers(i)
{
	if (SpeedTimer[i] != INVALID_HANDLE)
	{
		KillTimer(SpeedTimer[i]);
		SpeedTimer[i] = INVALID_HANDLE;
	}
	if (InvisTimer[i] != INVALID_HANDLE)
	{
		KillTimer(InvisTimer[i]);
		InvisTimer[i] = INVALID_HANDLE;
	}
	if (WhereTimer[i] != INVALID_HANDLE)
	{
		KillTimer(WhereTimer[i]);
		WhereTimer[i] = INVALID_HANDLE;
	}
}

public wS_WeaponFireOnEmpty(Handle:event, const String:name[], bool:dontBroadcast)
{
	new i = GetClientOfUserId(GetEventInt(event, "userid")), wS;
	if ((wS = GetEntPropEnt(i, Prop_Send, "m_hActiveWeapon")) > i)
	{
		decl String:wS_Weapon[32];
		GetEntityClassname(wS, wS_Weapon, sizeof(wS_Weapon));
		RemovePlayerItem(i, wS);
		GivePlayerItem(i, wS_Weapon);
		PrintToChat(i, "\x01[ \x03wS_Props_Mod\x01 ] Ваше оружие \x05обновлено");
	}
}

wS_GetLookPropIndex(i)
{
	decl Float:EyePosition[3], Float:EyeAngles[3], Handle:h_trace;
	GetClientEyePosition(i, EyePosition);
	GetClientEyeAngles(i, EyeAngles);
	h_trace = TR_TraceRayFilterEx(EyePosition, EyeAngles, MASK_SOLID, RayType_Infinite, wS_Filter, i);
	new Prop_Index = TR_GetEntityIndex(h_trace);
	CloseHandle(h_trace);
	if (Prop_Index < MaxClients)
	{
		return 0;
	}
	decl String:wS_Name[20];
	GetEntityClassname(Prop_Index, wS_Name, sizeof(wS_Name));
	if (StrEqual(wS_Name, "prop_dynamic"))
	{
		return Prop_Index;
	}
	return 0;
}

public Action:RespawnTimer_func(Handle:timer, any:wS_Schmidt)
{
	if (!props_on)
	{
		RespawnTimer = INVALID_HANDLE;
		return Plugin_Stop;
	}
	for (new i = 1; i <= MaxClients; i++)
	{
		if (IsClientInGame(i) && !IsPlayerAlive(i) && GetClientTeam(i) > 1)
		{
			CS_RespawnPlayer(i);
		}
	}
	return Plugin_Continue;
}

public Action:Say_DelOrRot(i, args)
{
	if (args < 1 && props_num > 0)
	{
		if (IsPlayerAlive(i) && GetClientTeam(i) == 3 || GetUserFlagBits(i) & ADMFLAG_CUSTOM2)
		{
			decl String:wS_CmD[7];
			GetCmdArg(0, wS_CmD, sizeof(wS_CmD));
			wS_RotateOrDeleteProp(i, StrEqual(wS_CmD, "del"));
		}
	}
	return Plugin_Handled;
}

// World-Source.Ru