#pragma semicolon 1

//Include
#include <sourcemod>
#include <sdktools>
#include <geoip>
#include <cstrike>
#undef REQUIRE_PLUGIN
#include <adminmenu>
#include <sdkhooks>

//Defines
#define MESS			"\x04[SM_Trikz] \x01%t"
#define GAMEDESC		"SM_Trikz/Trikz"
#define SERVERTAG		"Trikz"
#define PLUGIN_VERSION 	"0.4"
#define MAX_CLIENTS		64
#define MAX_BUFF		512
#define SMOKE_SPRITE	"materials/sprites/smoke.vmt"
#define EXPLOSION_SOUND	"/weapons/flashbang/flashbang_explode2.wav"

new flashbangs[MAXPLAYERS+1];
new jrespawn[MAXPLAYERS+1] = 1;
new autoswitch[MAXPLAYERS+1] = 0;
new autoflash[MAX_CLIENTS];

new Float:coords1[MAX_CLIENTS][3];
new Float:coords2[MAX_CLIENTS][3];
new bool:CV_overrideGameDesc = true;
new bool:MS_overrideGameDesc = true;
new g_iSmokeSprite = -1;

//Trikz Cvars
new Handle:sm_trikz_enableautoflash				= INVALID_HANDLE;
new Handle:sm_trikz_enableautoflashswitch		= INVALID_HANDLE;
new Handle:sm_trikz_settings			 		= INVALID_HANDLE;
new Handle:sm_trikz_airaccelerate		 		= INVALID_HANDLE;
new Handle:sm_trikz_ignoreradio			 		= INVALID_HANDLE;
new Handle:sm_trikz_override_gamedesc	 		= INVALID_HANDLE;
new Handle:sm_trikz_add_servertag		 		= INVALID_HANDLE;
new Handle:sm_trikz_enableteleport				= INVALID_HANDLE;
new Handle:sm_trikz_enableblock				 	= INVALID_HANDLE;
new Handle:sm_trikz_enableblockinvis            = INVALID_HANDLE;
new Handle:sm_trikz_enablerespawn				= INVALID_HANDLE;
new Handle:sm_trikz_version				 		= INVALID_HANDLE;
new Handle:sm_trikz_effects			 			= INVALID_HANDLE;
new Handle:sm_trikz_nofall                      = INVALID_HANDLE;

//Plugin Info
public Plugin:myinfo = 
{
	name = "Trikz",
	author = "3sigma",
	description = "Trikz plugin",
	version = PLUGIN_VERSION,
	url = "http://forums.alliedmods.net/showthread.php?t=136826/"
};

//Plugin Load
public OnPluginStart ()
{
	LoadTranslations("common.phrases");
	LoadTranslations("trikz.phrases");
	
	RegConsoleCmd("sm_block",				Command_Block,			"Toggle blocking");
	RegConsoleCmd("sm_respawn",				Command_Respawn,		"Respawn player");
	RegConsoleCmd("sm_flash",				Command_Flash,			"Give 1 flashbang");
	RegConsoleCmd("sm_autoflash",			Command_AutoFlash,		"Autoflash");
	RegConsoleCmd("sm_autoflashswitch",		Command_AutoFlashSwitch,"Autoflash Switch");
	RegConsoleCmd("sm_save1",				Command_Save1,			"Save checkpoint 1");
	RegConsoleCmd("sm_tele1",				Command_tele1,			"Teleport to checkpoint 1");
	RegConsoleCmd("sm_save2",				Command_Save2,			"Save checkpoint 2");
	RegConsoleCmd("sm_tele2",				Command_tele2,			"Teleport to checkpoint 2");
	
	//Menus
	RegConsoleCmd("sm_trikz",					Command_trikz,			"Show trikz menu");
	RegConsoleCmd("sm_tpmenu",			Command_TPMenu,			"Show teleport menu");
	RegConsoleCmd("sm_auto",			Command_AutoMenu,		"Show Auto menu");
	
	//Cvars
	sm_trikz_enableautoflash		= CreateConVar("sm_trikz_enableautoflash",		"1", 			"Enable or disable autoflash command: 0 - disable, 1 - enable");
	sm_trikz_enableautoflashswitch	= CreateConVar("sm_trikz_enableautoflashswitch","1", 			"Enable or disable autoflashswitch command: 0 - disable, 1 - enable");
	sm_trikz_settings 				= CreateConVar("sm_trikz_settings",				"1", 			"Enable or disable trikz settings (Airaccelerate, flashboost, friendlyfire and bhopenable): 0 - disable, 1 - enable");
	sm_trikz_airaccelerate 			= CreateConVar("sm_trikz_airaccelerate",		"100", 			"What should sv_airaccelerate  be (sm_trikz_settings needs to be enabled for this)");
	sm_trikz_ignoreradio 			= CreateConVar("sm_trikz_ignoreradio",			"1", 			"Enable or disable grenade radio (Fire in the hole!): 0 - disable, 1 - enable");
	sm_trikz_override_gamedesc 		= CreateConVar("sm_trikz_override_gamedesc", 	"1", 			"Enable or disable override of the game description (standard Counter-Strike: Source, override to SM_Trikz/Trikz): 0 - disable, 1 - enable");
	sm_trikz_add_servertag 			= CreateConVar("sm_trikz_add_servertag", 		"1", 			"Enable or disable new server tag : \"Trikz\" : 0 - disable, 1 - enable");
	sm_trikz_enableteleport 		= CreateConVar("sm_trikz_enableteleport", 		"1", 			"Enable or disable teleport menu/commands: 0 - disable, 1 - enable");
	sm_trikz_enableblock 			= CreateConVar("sm_trikz_enableblock", 			"1", 			"Enable or disable block command (!trikz_block): 0 - disable, 1 - enable");
	sm_trikz_enableblockinvis 		= CreateConVar("sm_trikz_enableblockinvis", 	"1", 			"Enable or disable invisibility when ghost (need sm_trikz_enableblock set to 1): 0 - disable, 1 - enable");
	sm_trikz_enablerespawn 			= CreateConVar("sm_trikz_enablerespawn", 		"1", 			"Enable or disable respawn command: 0 - disable, 1 - enable");
	sm_trikz_effects 				= CreateConVar("sm_trikz_effects",				"3", 			"Enable or disable effects on flashbang explosions : 0 - disable, 1 - enable sparks, 2 - enable sound, 3 - enable sparks & sound");
	sm_trikz_nofall                 = CreateConVar("sm_trikz_nofall", 				"1",            "Enable or disable fall damage: 0 - disable, 1 - enable");
	sm_trikz_version 				= CreateConVar("sm_trikz_version", 				PLUGIN_VERSION, "SM_Trikz plugin version (unchangeable)", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	
	HookConVarChange(sm_trikz_version, VersionChange);
	AutoExecConfig(true, "trikz");
	
	HookEvent("player_spawn",Event_spawn);  
	HookEvent("weapon_fire", Event_WeaponFire);
	HookEvent("item_pickup", Event_ItemPickup);
}

//Version Change
public VersionChange(Handle:convar, const String:oldValue[], const String:newValue[])
{
	SetConVarString(convar, PLUGIN_VERSION);
}

//Configs load
public OnConfigsExecuted()
{
	if(GetConVarInt(sm_trikz_ignoreradio))
	{
		ServerCommand("sv_ignoregrenaderadio 1");
	}
	
	if(GetConVarInt(sm_trikz_settings))
	{
		ServerCommand("sv_enablebunnyhopping 1");
		ServerCommand("sv_enableboost 1");
		ServerCommand("sv_friendlyfire 0");
		ServerCommand("sv_airaccelerate %i", GetConVarInt(sm_trikz_airaccelerate));
	}
	
	if(GetConVarInt(sm_trikz_add_servertag))
	{
		ServerCommand("sv_tags %s\n", SERVERTAG);
	}
}

//On Map Start
public OnMapStart()
{
	g_iSmokeSprite = PrecacheModel(SMOKE_SPRITE);
	
	PrecacheSound(EXPLOSION_SOUND, true);
	
	MS_overrideGameDesc = true;
}

//AutoMenu
public Action:Command_AutoMenu(client, args)
{
	if (client && IsClientInGame(client) && !IsFakeClient(client))
	{
		decl String:buff[MAX_BUFF];
		
		new Handle:menu = CreateMenu(MenuHandler_auto);
		if (args == -1) SetMenuExitBackButton(menu,true);
		
		SetMenuTitle(menu, "%t", "TZ menu auto title");
		
		if(GetConVarInt(sm_trikz_enableautoflash))
		{
			Format(buff,sizeof(buff),"%t","TZ menu autoflash");
			AddMenuItem(menu,"sm_trikz_autoflash",buff);
		}
		else
		{
			Format(buff,sizeof(buff),"%t","TZ menu autoflash disabled");
			AddMenuItem(menu,"sm_trikz_autoflash",buff);
		}
		
		
		if(GetConVarInt(sm_trikz_enableautoflashswitch))
		{
			Format(buff,sizeof(buff),"%t","TZ menu autoflash switch");
			AddMenuItem(menu,"sm_trikz_autoflashswitch",buff);
		}
		else
		{
			Format(buff,sizeof(buff),"%t","TZ menu autoflash switch disabled");
			AddMenuItem(menu,"sm_trikz_autoflashswitch",buff);
		}
		
		
		DisplayMenu(menu, client, MENU_TIME_FOREVER);
	}
	
	return Plugin_Handled;
}

//Auto Funcs
public MenuHandler_auto(Handle:menu, MenuAction:action, param1, param2)
{
	switch (action)
	{
		case MenuAction_Select :
		switch (param2)
		{
			case 0 :
			{
				if(GetConVarInt(sm_trikz_enableautoflash))
				{
					Command_AutoFlash(param1,0);
				}
				else
				{
					PrintToChat(param1, MESS, "TZ Command disabled");
				}
				Command_AutoMenu(param1,-1);
			}
			case 1 :
			{
				if(GetConVarInt(sm_trikz_enableautoflashswitch))
				{
					Command_AutoFlashSwitch(param1,0);
				}
				else
				{
					PrintToChat(param1, MESS, "TZ Command disabled");
				}
				Command_AutoMenu(param1,-1);
			}
		}
		case MenuAction_Cancel :
		if (param2 == MenuCancel_ExitBack) Command_trikz(param1,0);
		
		case MenuAction_End :
		CloseHandle(menu);
	}
}

// Trikz Menu options?
public Action:Command_trikz(client, args)
{
	if (client && IsClientInGame(client) && !IsFakeClient(client))
	{
		decl String:buff[MAX_BUFF];
		
		new Handle:menu = CreateMenu(MenuHandler_trikz);
		
		SetMenuTitle(menu, "%t", "TZ menu title");
		
		Format(buff,sizeof(buff),"%t","TZ menu flash");
		AddMenuItem(menu,"sm_trikz_flash",buff);
		
		Format(buff,sizeof(buff),"%t","TZ menu auto title");
		AddMenuItem(menu,"sm_trikz_automenu",buff);
		
		if(GetConVarInt(sm_trikz_enableblock))
		{
			Format(buff,sizeof(buff),"%t","TZ menu block");
			AddMenuItem(menu,"sm_trikz_block",buff);
		}
		else
		{
			Format(buff,sizeof(buff),"%t","TZ menu block disabled");
			AddMenuItem(menu,"sm_trikz_block",buff);
		}
		
		if(GetConVarInt(sm_trikz_enableteleport))
		{
			Format(buff,sizeof(buff),"%t","TZ menu checkpoints");
			AddMenuItem(menu,"sm_trikz_tpmenu",buff);
		}
		else
		{
			Format(buff,sizeof(buff),"%t","TZ menu checkpoints disabled");
			AddMenuItem(menu,"sm_trikz_tpmenu",buff);
		}
		
		if(GetConVarInt(sm_trikz_enablerespawn))
		{
			Format(buff,sizeof(buff),"%t","TZ menu respawn");
			AddMenuItem(menu,"sm_trikz_respawn",buff);
		}
		else
		{
			Format(buff,sizeof(buff),"%t","TZ menu respawn disabled");
			AddMenuItem(menu,"sm_trikz_respawn",buff);
		}
		
		Format(buff, sizeof(buff), "%s", "Credits");
		AddMenuItem(menu, "sm_trikz_credits", buff);
		
		DisplayMenu(menu, client, MENU_TIME_FOREVER);
	}
	
	return Plugin_Handled;
}

// Trikz Funcs
public MenuHandler_trikz(Handle:menu, MenuAction:action, param1, param2)
{
	if (action == MenuAction_Select)
		switch (param2)
	{
		case 0 :
		{
			Command_Flash(param1,0);
			Command_trikz(param1,-1);
		}
		case 1 :
		{
			Command_AutoMenu(param1,-1);
		}
		case 2 :
		{
			Command_Block(param1,-1);
			Command_trikz(param1,-1);
		}
		case 3 :
		{
			if(GetConVarInt(sm_trikz_enableteleport))
			{
				Command_TPMenu(param1,-1);
			}
			else
			{
				PrintToChat(param1, MESS, "TZ Command disabled");
				Command_trikz(param1,-1);
			}
		}
		case 4 :
		{
			if(GetConVarInt(sm_trikz_enablerespawn))
			{
				Command_Respawn(param1,0);
			}
			else
			{
				PrintToChat(param1, MESS, "TZ Command disabled");
			}
			Command_trikz(param1,-1);
		}
		case 5 :
		{
			PrintToChat(param1, MESS, "TZ Credits");
			Command_trikz(param1,-1);
		}
	} 
	else if(action == MenuAction_End)
	{
		CloseHandle(menu);
	}
}

public Action:Command_TPMenu(client, args)
{
	if (client && IsClientInGame(client) && !IsFakeClient(client))
	{
		decl String:buff[MAX_BUFF];
		
		new Handle:menu = CreateMenu(MenuHandler_TPMenu);
		if (args == -1) SetMenuExitBackButton(menu,true);
		
		SetMenuTitle(menu, "%t", "TZ menu checkpoints");
		
		if(GetConVarInt(sm_trikz_enableteleport))
		{
			Format(buff,sizeof(buff),"%t","TZ menu save 1");
			AddMenuItem(menu,"sm_save1",buff);
			
			Format(buff,sizeof(buff),"%t","TZ menu teleport 1");
			AddMenuItem(menu,"sm_tele1",buff);
		}
		else
		{
			Format(buff,sizeof(buff),"%t","TZ menu save 1 disabled");
			AddMenuItem(menu,"sm_save1",buff);
			
			Format(buff,sizeof(buff),"%t","TZ menu teleport 1 disabled");
			AddMenuItem(menu,"sm_tele1",buff);
		}
		
		
		AddMenuItem(menu,"sep","",ITEMDRAW_SPACER);
		
		
		if(GetConVarInt(sm_trikz_enableteleport))
		{
			Format(buff,sizeof(buff),"%t","TZ menu save 2");
			AddMenuItem(menu,"sm_save2",buff);
			
			Format(buff,sizeof(buff),"%t","TZ menu teleport 2");
			AddMenuItem(menu,"sm_tele2",buff);
		}
		else
		{
			Format(buff,sizeof(buff),"%t","TZ menu save 2 disabled");
			AddMenuItem(menu,"sm_save2",buff);
			
			Format(buff,sizeof(buff),"%t","TZ menu teleport 2 disabled");
			AddMenuItem(menu,"sm_tele2",buff);
		}
		
		DisplayMenu(menu, client, MENU_TIME_FOREVER);
	}
	
	return Plugin_Handled;
}

//Teleport Funcs
public MenuHandler_TPMenu(Handle:menu, MenuAction:action, param1, param2)
{
	switch (action)
	{
		case MenuAction_Select :
		switch (param2)
		{
			case 0 :
			{
				Command_Save1(param1,0);
				Command_TPMenu(param1,-1);
			}
			case 1 :
			{
				Command_tele1(param1,0);
				Command_TPMenu(param1,-1);
			}
			case 3 :
			{
				Command_Save2(param1,0);
				Command_TPMenu(param1,-1);
			}
			case 4 :
			{
				Command_tele2(param1,0);
				Command_TPMenu(param1,-1);
			}
		}
		case MenuAction_Cancel :
		if (param2 == MenuCancel_ExitBack) Command_trikz(param1,0);
		
		case MenuAction_End :
		CloseHandle(menu);
	}
}

//Block
public Action:Command_Block(client, args)
{
	block(client);
	return Plugin_Handled;
}


block(client)
{
	if(GetConVarInt(sm_trikz_enableblock))
	{
		if (IsPlayerAlive(client))
		{
			new col = GetEntProp(client, Prop_Data, "m_CollisionGroup");
			if (col == 5)
			{
				SetEntProp(client, Prop_Data, "m_CollisionGroup", 2);
				PrintToChat(client, MESS, "TZ block off");
				
				if(GetConVarInt(sm_trikz_enableblockinvis))
					CreateInvis(client, 100);
			}
			else
			{
				SetEntProp(client, Prop_Data, "m_CollisionGroup", 5);
				PrintToChat(client, MESS, "TZ block on");
				
				switch(flashbangs[client])
				{
					case 1:
					{
						jrespawn[client] = 2;
					}
					case 2:
					{
						jrespawn[client] = 2;
					}
				}
				
				if(GetConVarInt(sm_trikz_enableblockinvis))
					CreateInvis(client, 255);
			}
		}
		else
		{
			PrintToChat(client, MESS, "TZ Dead");
		}
	}
	else
	{
		PrintToChat(client, MESS, "TZ Command disabled");
	}
}

// Respawn
public Action:Command_Respawn(client, args)
{
	if(GetConVarInt(sm_trikz_enablerespawn))
	{
		if (IsClientInGame(client) && !IsFakeClient(client) && GetClientTeam(client) > 1)
		{
			switch(flashbangs[client])
			{
				case 1:
				{
					jrespawn[client] = 2;
				}
				case 2:
				{
					jrespawn[client] = 2;
				}
			}
			
			CS_RespawnPlayer(client);
			PrintToChat(client, MESS, "TZ respawn");
		}
		else
		{
			PrintToChat(client, MESS, "TZ Spec respawn");
		}
		return Plugin_Handled;
	}
	else
	{
		PrintToChat(client, MESS, "TZ Command disabled");
	}
	
	return Plugin_Handled;
}

//Weapon Fire
public Action:Event_WeaponFire(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	decl String:weapon[MAX_BUFF];
	GetEventString(event,"weapon",weapon,sizeof(weapon));
	
	if (StrEqual(weapon,"flashbang"))
	{
		flashbangs[client]--;
		
		if(autoflash[client])
		{
			give(client);
			
			if(autoswitch[client] == 1)
			{
				CreateTimer(0.8, selectf, client);
			}
		}
	}
}

public Action:selectf(Handle:timer, any:client)
{
	FakeClientCommand(client, "use weapon_flashbang");
}

//Flashbang created
public OnEntityCreated(edict, const String:classname[])
{
	if (IsValidEdict(edict) && IsValidEntity(edict) && StrEqual(classname, "flashbang_projectile"))
	{
		CreateTimer(1.2, Timer_RemoveFlashbang, edict);
	}
}

//Remove Flashbang
public Action:Timer_RemoveFlashbang(Handle:timer, any:edict)
{
	decl String:classname[MAX_BUFF];
	GetEdictClassname(edict,classname,sizeof(classname));
	if (!IsValidEdict(edict) || !IsValidEntity(edict) || !StrEqual(classname, "flashbang_projectile"))
	{
		return Plugin_Stop;
	}
	if(GetConVarInt(sm_trikz_effects) != 0)
	{
		new Float:fPos[3];
		GetEntPropVector(edict, Prop_Send, "m_vecOrigin", fPos);
		
		if(GetConVarInt(sm_trikz_effects) == 1)
		{
			TE_SetupSparks(fPos, NULL_VECTOR, 1, 2);
			TE_SendToAll();
			TE_SetupSmoke(fPos, g_iSmokeSprite, 1.0, 15);
			TE_SendToAll();
		}
		else if(GetConVarInt(sm_trikz_effects) == 2)	
		{
			EmitAmbientSound(EXPLOSION_SOUND, fPos);
		}
		else if(GetConVarInt(sm_trikz_effects) == 3)
		{
			TE_SetupSparks(fPos, NULL_VECTOR, 1, 2);
			TE_SendToAll();
			TE_SetupSmoke(fPos, g_iSmokeSprite, 1.0, 15);
			TE_SendToAll();
			
			EmitAmbientSound(EXPLOSION_SOUND, fPos);
		}
	}
	
	AcceptEntityInput(edict, "Kill");
	return Plugin_Stop;
}

//Command Flash
public Action:Command_Flash(client, args)
{
	if (IsPlayerAlive(client))
	{
		if (client && IsClientInGame(client) && !IsFakeClient(client))
		{
			if(autoflash[client])
			{
				PrintToChat(client, MESS, "TZ autoflash flash");
			}
			else
			{
				if(flashbangs[client] >= 2)
				{
					PrintToChat(client, MESS, "TZ flashbangs");
				}
				else
				{
					PrintToChat(client, MESS, "TZ flash");
					if(jrespawn[client] == 2)
					{
						flashbangs[client]++;
					}
					give(client);
				}
			}
		}
	}
	else
	{
		PrintToChat(client, MESS, "TZ Dead");
	}
	return Plugin_Handled;
}

//Autoflash
public Action:Command_AutoFlash(client, args)
{
	if(GetConVarInt(sm_trikz_enableautoflash))
	{
		auto(client, 0);
		return Plugin_Handled;
	}
	else
	{
		PrintToChat(client, MESS, "TZ Command disabled");
	}
	
	return Plugin_Handled;
}

//AutoflashSwitch
public Action:Command_AutoFlashSwitch(client, args)
{
	if(GetConVarInt(sm_trikz_enableautoflashswitch))
	{
		auto(client, 1);
		return Plugin_Handled;
	}
	else
	{
		PrintToChat(client, MESS, "TZ Command disabled");
	}
	
	return Plugin_Handled;
}

auto(client, opt)
{
	if (IsPlayerAlive(client))
	{
		if(autoflash[client])
		{
			autoflash[client] = 0;
			PrintToChat(client, MESS, "TZ autoflash off");
			autoswitch[client] = 0;
		}
		else
		{
			autoflash[client] = 1;
			PrintToChat(client, MESS, "TZ autoflash on");
			
			if(flashbangs[client] <= 0)
			{
				give(client);
			}
			
			if(opt == 1)
			{
				autoswitch[client] = 1;
			}
		}
	}
	else
	{
		PrintToChat(client, MESS, "TZ Dead");
	}
}

//Client Put Server
public OnClientPutInServer(client)
{	
	if(GetConVarInt(sm_trikz_nofall))
	{
		SDKHook(client, SDKHook_OnTakeDamage, OnTakeDamage);
	}

	coords1[client][0] = 0.0;
	coords1[client][1] = 0.0;
	coords1[client][2] = 0.0;
	coords2[client][0] = 0.0;
	coords2[client][1] = 0.0;
	coords2[client][2] = 0.0;
	
	CreateTimer(5.0, welcome, client);
}

//Welcome
public Action:welcome(Handle:timer, any:client)
{
	PrintToChat(client, MESS, "TZ autohi");
	
	return Plugin_Stop;
}

//Spawn
public Action:Event_spawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event,"userid"));
	if(GetClientTeam(client) >= 2)
	{
		strip(client);
		autoflash[client]	= 0;
		autoswitch[client]	= 0;
	}
}

//Save1 Loc
public Action:Command_Save1(client, args)
{
	if (IsPlayerAlive(client))
	{
		if (GetEntDataEnt2(client, FindSendPropOffs("CBasePlayer", "m_hGroundEntity")) != -1)
		{
			GetEntPropVector(client, Prop_Send, "m_vecOrigin", coords1[client]);
			PrintToChat(client, MESS, "TZ save 1");
		}
		else
		{
			PrintToChat(client, MESS, "TZ Ground");
		}
	}
	else
	{
		PrintToChat(client, MESS, "TZ Dead");
	}
	return Plugin_Handled;
}

//Teleport1
public Action:Command_tele1(client, args)
{
	if (IsPlayerAlive(client))
	{
		if(!(coords1[client][0] == 0.0 && coords1[client][1] == 0.0 && coords1[client][2] == 0.0))
		{
			TeleportEntity(client, coords1[client], NULL_VECTOR, NULL_VECTOR);
			PrintToChat(client, MESS, "TZ teleport 1");
		}
		else
		{
			PrintToChat(client, MESS,"TZ no teleport");
		}
	}
	else
	{
		PrintToChat(client, MESS, "TZ Dead");
	}
	return Plugin_Handled;
}

//Save2 Loc
public Action:Command_Save2(client, args)
{
	if (IsPlayerAlive(client))
	{
		if (GetEntDataEnt2(client, FindSendPropOffs("CBasePlayer", "m_hGroundEntity")) != -1)
		{
			GetEntPropVector(client, Prop_Send, "m_vecOrigin", coords2[client]);
			PrintToChat(client, MESS, "TZ save 2");
		}
		else
		{
			PrintToChat(client, MESS, "Ground");
		}
	}
	else
	{
		PrintToChat(client, MESS, "TZ Dead");
	}
	return Plugin_Handled;
}

//Teleport2
public Action:Command_tele2(client, args)
{
	if (IsPlayerAlive(client))
	{
		if(!(coords1[client][0] == 0.0 && coords1[client][1] == 0.0 && coords2[client][2] == 0.0))
		{
			TeleportEntity(client, coords2[client], NULL_VECTOR, NULL_VECTOR);
			PrintToChat(client, MESS, "TZ teleport 2");
		}
		else
		{
			PrintToChat(client, MESS,"TZ no teleport");
		}
	}
	else
	{
		PrintToChat(client, MESS, "TZ Dead");
	}
	return Plugin_Handled;
}

//Strip
strip(client)
{
	new wepIdx;
	for( new i = 0; i < 47; i++ )
	{
		while((wepIdx = GetPlayerWeaponSlot(client, i)) != -1)
		{
			RemovePlayerItem(client,wepIdx );
		}
	}
	flashbangs[client] 	= 0;
	GivePlayerItem(client, "weapon_knife");
	GivePlayerItem(client, "weapon_usp");
}

//Give
give(client)
{
	GivePlayerItem(client, "weapon_flashbang");
	FakeClientCommand(client, "use weapon_flashbang");
}

//Start Creating Invis
CreateInvis(target, alpha)    
{
	SetAlpha(target,alpha);
}

//Player Invis
SetAlpha(target, alpha)
{        
	SetWeaponsAlpha(target,alpha);
	SetEntityRenderMode(target, RENDER_TRANSCOLOR);
	SetEntityRenderColor(target, 255, 255, 255, alpha);    
}

//Weapon Invis
SetWeaponsAlpha(target, alpha)
{
	if(IsPlayerAlive(target))
	{
		new m_hMyWeapons = FindSendPropOffs("CBasePlayer", "m_hMyWeapons");    
		for(new i = 0, weapon; i < 47; i += 4)
		{
			weapon = GetEntDataEnt2(target, m_hMyWeapons + i);
			
			if(weapon > -1 )
			{
				SetEntityRenderMode(weapon, RENDER_TRANSCOLOR);
				SetEntityRenderColor(weapon, 255, 255, 255, alpha);
			}
		}
	}
}

//On Take Damage
public Action:OnTakeDamage(client, &attacker, &inflictor, &Float:damage, &damagetype)
{
	if(GetConVarInt(sm_trikz_nofall))
	{
		if (damagetype & DMG_FALL)
		{
			return Plugin_Stop;
		}
	}
	
	return Plugin_Continue;
}


//Change Desc
public Action:OnGetGameDescription(String:gameDesc[64])
{
	if (CV_overrideGameDesc && MS_overrideGameDesc && GetConVarInt(sm_trikz_override_gamedesc))
	{
		strcopy(gameDesc, sizeof(gameDesc), GAMEDESC);
		return Plugin_Changed;
	}
	
	return Plugin_Continue;
}

//Item Pickup
public Event_ItemPickup(Handle:event,const String:name[],bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	new String:ItemName[32];
	GetEventString(event,"item",ItemName,sizeof(ItemName));
	
	if(StrEqual(ItemName, "flashbang"))
	{
		flashbangs[client]++;
	}
}