#include <sourcemod>
#include <sdktools>

#pragma semicolon 1

#define TEAM_NONE 0
#define TEAM_SPEC 1
#define TEAM_T 2
#define TEAM_CT 3

new Handle:hKVSettings;
new bool:IsPlayerHasVIP[MAXPLAYERS+1];
new PlayerSettings[MAXPLAYERS+1][2];
new g_iAccount = -1;
new String:s_FileSettingsPath[] = "addons/sourcemod/configs/vip_users.ini";
new Handle:g_CvarSoundName;
new String:g_soundName[PLATFORM_MAX_PATH];

new g_Tcount, g_CTcount;
new bool:g_balance;

public Plugin:myinfo = 
{
	name = "VIP plugin",
	author = "NoTiCE",
	description = "VIP plugin",
	version = "1.0",
	url = "http://uaplayer.com/"
}

public OnPluginStart()
{
	LoadTranslations("vip_plugin.phrases");
	
	g_iAccount = FindSendPropOffs("CCSPlayer", "m_iAccount");
	
	g_CvarSoundName = CreateConVar("sm_vip_sound", "consnd/joinserver.mp3", "The sound to play");
	
	RegConsoleCmd("say", Command_Say);
	RegConsoleCmd("say_team", Command_SayTeam);
	RegConsoleCmd("jointeam", Command_jointeam);
	
	HookEvent("player_spawn", Event_PlayerSpawn);
	HookEvent("player_death", Event_PlayerDeath);
	HookEvent("player_team", Event_PlayerTeam);
	
	AutoExecConfig(true, "vip_plugin");
}

public OnConfigsExecuted()
{
	hKVSettings=CreateKeyValues("VIP_Users");
	
	if (!FileToKeyValues(hKVSettings, s_FileSettingsPath))
	{
		SetFailState("File '%s' not found!", s_FileSettingsPath);
	}
	
	GetConVarString(g_CvarSoundName, g_soundName, PLATFORM_MAX_PATH);
	decl String:buffer[PLATFORM_MAX_PATH];
	PrecacheSound(g_soundName, true);
	Format(buffer, sizeof(buffer), "sound/%s", g_soundName);
	AddFileToDownloadsTable(buffer);
}

public OnMapStart()
{
	ServerCommand("mp_autoteambalance 0");
	ServerCommand("mp_limitteams 0");
	
	g_Tcount = 0;
	g_CTcount = 0;
	for(new i = 1; i <= MaxClients; i++)
	{
		if (IsClientInGame(i))
		{
			ChangeTeamCount(GetClientTeam(i), 1);
		}
	}
	
	CheckBalance();
}

public Event_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if (!client || !IsPlayerHasVIP[client] || IsFakeClient(client) || !IsPlayerAlive(client))
	{
		return;
	}
	
	CreateTimer(0.1, SetVIPBonus, client, TIMER_FLAG_NO_MAPCHANGE);
}

public Action:SetVIPBonus(Handle:timer, any:client)
{
	if(IsPlayerAlive(client))
	{
		SetEntityHealth(client, PlayerSettings[client][0]);
		SetEntProp(client, Prop_Send, "m_ArmorValue", PlayerSettings[client][1], 1);
		
		if (g_iAccount != -1)
		{
			SetEntData(client, g_iAccount, 16000);
		}
	}
}

public OnClientPutInServer(client)
{
	if (!client || IsFakeClient(client))
	{
		return;
	}
	
	IsPlayerHasVIP[client] = false;
	
	decl String:steam_id[21];
	GetClientAuthString(client, steam_id, sizeof(steam_id));
	
	KvRewind(hKVSettings);
	
	if (KvJumpToKey(hKVSettings, steam_id, false))
	{
		IsPlayerHasVIP[client] = true;
		
		PlayerSettings[client][0] = KvGetNum(hKVSettings, "hp", 0);
		PlayerSettings[client][1] = KvGetNum(hKVSettings, "armor", 0);
	}
}

public OnClientPostAdminCheck(client)
{
	if(IsPlayerHasVIP[client])
	{
		EmitSoundToClient(client,g_soundName);
	}
}

public Action:Command_SayTeam(client, args)
{
	if(IsPlayerHasVIP[client])
	{
		new String:buffer[300], String:name[64];
		GetCmdArgString(buffer, sizeof(buffer));
		GetClientName(client, name, sizeof(name));
		new ClientTeam = GetClientTeam(client);
		
		new maxplayers=GetMaxClients()+1;
		
		for(new i=1;i<maxplayers;i++)
		{
			if (!(IsClientInGame(i)))
			{
				continue;
			}
			
			if((ClientTeam == 1) && (GetClientTeam(i) == ClientTeam))
			{
				PrintToChat(i, "\x04(VIP) %s (Spectators): %s", name, buffer);
			}
			
			if((ClientTeam == 2) && GetClientTeam(i) == ClientTeam)
			{
				PrintToChat(i, "\x04(VIP) %s (Counter-Terrorists): %s", name, buffer);
			}
			
			if((ClientTeam == 3) && GetClientTeam(i) == ClientTeam)
			{
				PrintToChat(i, "\x01(\x04VIP\x01) x\04%s (Terrorists): %s", name, buffer);
			}			
		}
		
		return Plugin_Handled;
	}
	
	return Plugin_Continue;
}

public Action:Command_Say(client, args)
{
	if(IsPlayerHasVIP[client])
	{
		new String:buffer[300], String:name[64];
		GetCmdArgString(buffer, sizeof(buffer));
		GetClientName(client, name, sizeof(name));
		
		new maxplayers=GetMaxClients()+1;
		
		for(new i=1;i<maxplayers;i++)
		{
			if (!(IsClientInGame(i)))
			{
				continue;
			}
			
			PrintToChat(i, "\x04(VIP) %s : %s", name, buffer);
		}
		
		return Plugin_Handled;
	}
	
	return Plugin_Continue;
}

public Action:Command_jointeam(client, args)
{
	if (!client || !IsClientInGame(client) || IsFakeClient(client))
	{
		return Plugin_Continue;
	}
	
	decl String:teamString[3];
	GetCmdArg(1, teamString, sizeof(teamString));
	
	new newTeam = StringToInt(teamString);
	new oldTeam = GetClientTeam(client);
	
	if((newTeam == TEAM_T) && (newTeam != oldTeam) && (g_Tcount - g_CTcount >= 2) && (!IsPlayerHasVIP[client]))
	{
		ClientCommand(client, "play ui/freeze_cam.wav");
		PrintToChat(client, "\x01[\x04Balance\x01] %t", "transfer denied to T");
		
		return Plugin_Handled;
	}
	
	if((newTeam == TEAM_CT) && (newTeam != oldTeam) && (g_CTcount - g_Tcount >= 2) && (!IsPlayerHasVIP[client]))
	{
		ClientCommand(client, "play ui/freeze_cam.wav");
		PrintToChat(client, "\x01[\x04Balance\x01] %t", "transfer denied to CT");
		
		return Plugin_Handled;
	}
	
	return Plugin_Continue;
}

public Action:Event_PlayerDeath(Handle:event,const String:name[],bool:dontBroadcast)
{
	if ( g_balance )
    {
        return;
    }
	
	new killer = GetClientOfUserId(GetEventInt(event, "attacker"));
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if((client == killer) || IsFakeClient(client))
	{
		return;
	}
	
	new team = GetClientTeam(client);
	
	if( team != TEAM_T && team != TEAM_CT )
    {
        return;
    }
	
	if( team != ( (g_Tcount > g_CTcount) ? TEAM_T : TEAM_CT ) )
	{
		return;
	}
	
	team = team == TEAM_T ? TEAM_CT : TEAM_T;
	
	new Handle:pack = CreateDataPack();
	WritePackCell(pack, client);
	WritePackCell(pack, team);
	CreateTimer(0.1, Timer_ChangeClientTeam, pack);
}

public Action:Timer_ChangeClientTeam(Handle:timer, any:pack)
{
	ResetPack(pack);
	new client = ReadPackCell(pack);
	new team = ReadPackCell(pack);
	CloseHandle(pack);
	if(!(IsPlayerHasVIP[client]))
	{
		ChangeClientTeam(client, team);
	}
}

public Event_PlayerTeam(Handle:event, const String:name[], bool:dontBroadcast)
{
    new oldTeam         = GetEventInt(event, "oldteam");
    new newTeam         = GetEventInt(event, "team");
    new bool:disconnect = GetEventBool(event, "disconnect");

    ChangeTeamCount(oldTeam, -1);

    if ( !disconnect ) {
        ChangeTeamCount(newTeam, 1);
    }

    CheckBalance();
}

CheckBalance()
{
    new diff = g_Tcount - g_CTcount;
    if ( diff < 0 ) diff = -diff;
    g_balance = diff <= 1;
}

ChangeTeamCount(team, diff)
{
    switch ( team ) {
        case TEAM_T: {
            g_Tcount += diff;
        }
        case TEAM_CT: {
            g_CTcount += diff;
        }
    }
}