#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <colors>
#include <cstrike>
#include <smlib>

public Plugin:myinfo = 
{
	name = "Svinorez",
	author = "NoTiCE",
	description = "Sets the skin to the player who killed with a knife",
	version = "1.1",
	url = "http://hlmod.ru/"
}

new Handle:g_hCT_Skin_Cvar, Handle:g_hT_Skin_Cvar, Handle:g_hSoundPath_Cvar;

new String:g_sCT_SkinPath[PLATFORM_MAX_PATH], String:g_sT_SkinPath[PLATFORM_MAX_PATH], String:g_sSoundPath[PLATFORM_MAX_PATH],
	String:g_sModelBuffer[PLATFORM_MAX_PATH];

new bool:g_bSvinExist;

new g_iSvinorez;

static String:AllModels[][PLATFORM_MAX_PATH] =
{
	"models/player/t_phoenix.mdl",
	"models/player/t_leet.mdl",
	"models/player/t_arctic.mdl",
	"models/player/t_guerilla.mdl",
	"models/player/ct_urban.mdl",
	"models/player/ct_gsg9.mdl",
	"models/player/ct_sas.mdl",
	"models/player/ct_gign.mdl"
};

public OnPluginStart()
{
	LoadTranslations("svinorez.phrases");
	
	g_hT_Skin_Cvar = CreateConVar("sm_svin_skin_t", "models/player/ics/t_leet_kking/t_leet.mdl", "T model path");
	g_hCT_Skin_Cvar = CreateConVar("sm_svin_skin_ct", "models/player/ics/ct_gign_kking/ct_gign.mdl", "CT model path");
	g_hSoundPath_Cvar = CreateConVar("sm_svin_sound", "svinorez/kaban4eg.mp3", "Sound path");
	
	HookEvent("round_start", Event_RoundStart);
	HookEvent("player_death", Event_PlayerDeath);
	HookEvent("player_spawn", Event_PlayerSpawn);
	
	RegConsoleCmd("joinclass", Command_JoinClass, "Joinclass hook");
	
	AutoExecConfig(true, "svinorez");
}

public OnConfigsExecuted()
{
	decl String:Path[PLATFORM_MAX_PATH];
	BuildPath(Path_SM, Path, sizeof(Path), "configs/svindownloads.ini");
	
	if (FileExists(Path))
		File_ReadDownloadList(Path);
	else
		LogError("Downloadslist '%s' not found", Path);
	
	GetConVarString(g_hCT_Skin_Cvar, g_sCT_SkinPath, sizeof(g_sCT_SkinPath));
	GetConVarString(g_hT_Skin_Cvar, g_sT_SkinPath, sizeof(g_sT_SkinPath));
	
	PrecacheModel(g_sCT_SkinPath, false);
	PrecacheModel(g_sT_SkinPath, false);
	
	decl String:sBuffer[PLATFORM_MAX_PATH];
	GetConVarString(g_hSoundPath_Cvar, g_sSoundPath, sizeof(g_sSoundPath));
	PrecacheSound(g_sSoundPath, true);
	Format(sBuffer, sizeof(sBuffer), "sound/%s", g_sSoundPath);
	AddFileToDownloadsTable(sBuffer);
}

public Event_RoundStart(Handle:event,const String:name[],bool:dontBroadcast)
{
	if(g_bSvinExist)
		CreateTimer(0.1, SetSkin, g_iSvinorez, TIMER_FLAG_NO_MAPCHANGE);
}

public Event_PlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	
	if(g_bSvinExist && client == g_iSvinorez && IsClientInGame(client))
		CreateTimer(0.1, SetSkin, client, TIMER_FLAG_NO_MAPCHANGE);
}

public Event_PlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));
	
	if(!attacker || attacker > MaxClients || !IsClientInGame(attacker) || !IsPlayerAlive(attacker))
		return;
	
	decl String:sWeapon[30];
	GetEventString(event, "weapon", sWeapon, sizeof(sWeapon));
	
	if(strcmp(sWeapon, "knife", false) == 0)
	{
		new victim = GetClientOfUserId(GetEventInt(event, "userid"));
		new VictimTeam = GetClientTeam(victim);
		new AttackerTeam = GetClientTeam(attacker);
		
		if(!g_bSvinExist && VictimTeam != AttackerTeam)
		{
			GetClientModel(attacker, g_sModelBuffer, sizeof(g_sModelBuffer));
			g_bSvinExist = true;
			g_iSvinorez = attacker;
			CreateTimer(0.1, SetSkin, attacker, TIMER_FLAG_NO_MAPCHANGE);
			CPrintToChatAll("%t", "svinorez_message", attacker, victim);
			EmitSoundToAll(g_sSoundPath, _, _, SNDLEVEL_DRYER, _, SNDVOL_NORMAL, _, _, _, _, _, _);
			
			return;
		}
		
		if(g_bSvinExist && VictimTeam != AttackerTeam)
		{
			if(victim == g_iSvinorez)
			{
				new ragdoll = GetEntPropEnt(victim, Prop_Send, "m_hRagdoll");
				SetEntityModel(ragdoll, g_sModelBuffer);
			}
			else
			{
				if(!IsClientInGame(g_iSvinorez) || IsFakeClient(g_iSvinorez) || !IsPlayerAlive(g_iSvinorez))
					return;
				
				SetEntityModel(g_iSvinorez, g_sModelBuffer);
			}
			
			GetClientModel(attacker, g_sModelBuffer, sizeof(g_sModelBuffer));
			g_iSvinorez = attacker;
			CreateTimer(0.1, SetSkin, attacker, TIMER_FLAG_NO_MAPCHANGE);
			CPrintToChatAll("%t", "svinorez_message", attacker, victim);
			EmitSoundToAll(g_sSoundPath, _, _, SNDLEVEL_DRYER, _, SNDVOL_NORMAL, _, _, _, _, _, _);
		}
	}
}

public Action:Command_JoinClass(client, args)
{
	if(g_bSvinExist && client == g_iSvinorez)
	{
		decl String:Args[3];
		GetCmdArg(1, Args, sizeof(Args));
		g_sModelBuffer = AllModels[StringToInt(Args)-1];
	}
	
	return Plugin_Continue;
}

public OnClientDisconnect(client)
{
	if(client == g_iSvinorez)
		g_bSvinExist = false;
}

public Action:SetSkin(Handle:timer, any:client)
{
	switch(GetClientTeam(client))
	{
		case(CS_TEAM_CT):
		{
			SetEntityModel(client, g_sCT_SkinPath);
		}
		
		case(CS_TEAM_T):
		{
			SetEntityModel(client, g_sT_SkinPath);
		}
	}
	
	return Plugin_Continue;
}