# ../addons/eventscripts/gungame51/scripts/cfg/included/gg_warmup_round.py

'''
$Rev: 414 $
$LastChangedBy: WarrenAlpert $
$LastChangedDate: 2010-04-13 15:33:58 -0400 (Tue, 13 Apr 2010) $
'''

# ============================================================================
# >> IMPORTS
# ============================================================================
# EventScripts Imports
import es
import cfglib

# GunGame Imports
from gungame51.core.cfg import generate_header

# ============================================================================
# >> GLOBAL VARIABLES
# ============================================================================
config = cfglib.AddonCFG('%s/cfg/' %es.ServerVar('eventscripts_gamedir') +
    'gungame51/included_addon_configs/gg_earn_nade.cfg')
        
# ============================================================================
# >> LOAD & UNLOAD
# ============================================================================
def load():
    generate_header(config)
    
    # Earn Grenade
    config.text('')
    config.text('='*76)
    config.text('>> EARN GRENADES')
    config.text('='*76)
    config.text('Description:')
    config.text('   When a player reaches grenade level, they can earn extra' +
                ' grenades by')
    config.text('   killing enemies with another weapon.')
    config.text('Note:')
    config.text('   * Players can only carry one hegrenade at a time.')
    config.text('Options:')
    config.text('   0 = (Disabled) Do not load gg_earn_nade.')
    config.text('   1 = (Enabled) Load gg_earn_nade.')
    config.text('Default Value: 0')
    config.cvar('gg_earn_nade', 0, 'Enables/Disables ' +
                'gg_earn_nade.').addFlag('notify')
    
    config.write()
    es.dbgmsg(0, '\tgg_earn_nade.cfg')

def unload():
    global config

    # Remove the "notify" flags as set by addFlag('notify')
    for cvar in config.getCvars().keys():
        es.flags('remove', 'notify', cvar)
    
    # Delete the cfglib.AddonCFG instance
    del config