# ../addons/eventscripts/gungame51/scripts/included/gg_noblock/gg_noblock.py

'''
$Rev: 479 $
$LastChangedBy: micbarr $
$LastChangedDate: 2010-07-24 11:50:42 -0400 (Sat, 24 Jul 2010) $
'''

# ============================================================================
# >> IMPORTS
# ============================================================================
# Eventscripts Imports
import es
from playerlib import getPlayer
from playerlib import getPlayerList

# GunGame Imports
from gungame51.core.addons.shortcuts import AddonInfo

# ============================================================================
# >> ADDON REGISTRATION/INFORMATION
# ============================================================================
info = AddonInfo()
info.name = 'gg_noblock'
info.title = 'GG No Block' 
info.author = 'GG Dev Team' 
info.version = "5.1.%s" %"$Rev: 479 $".split('$Rev: ')[1].split()[0]

# ============================================================================
# >> LOAD & UNLOAD
# ============================================================================
def load():
    es.dbgmsg(0, 'Loaded: %s' % info.name)

    # Enable noblock for every player that is alive and on a team
    for player in getPlayerList('#alive'):
        player.noblock = 1

def unload():
    es.dbgmsg(0, 'Unloaded: %s' % info.name)

    # Disable noblock for every player that is alive and on a team
    for player in getPlayerList('#alive'):
        player.noblock = 0

# ============================================================================
# >> GAME EVENTS
# ============================================================================
def player_spawn(event_var):
    # Is the player on a team
    if not int(event_var['es_userteam']) > 1:
        return

    # Enable noblock for this player
    getPlayer(event_var['userid']).noblock = 1